/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_INCDEC_GRP5
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] oldSource = new byte[2];
    byte[] incWord;
    byte[] newCS = new byte[2];
    byte[] newIP = new byte[2];
    int intermediateResult = 0;
    byte displacementByte = 0;
    byte[] displacementWord;
    int overUnderFlowCheck;
    byte[] temp;
    private static final Logger logger = Logger.getLogger(Instruction_INCDEC_GRP5.class.getName());

    public Instruction_INCDEC_GRP5() {
        this.incWord = new byte[]{0, 1};
        this.displacementWord = new byte[2];
        this.temp = new byte[2];
    }

    public Instruction_INCDEC_GRP5(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.sourceValue = new byte[2];
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                System.arraycopy(this.sourceValue, 0, this.oldSource, 0, this.sourceValue.length);
                this.temp = Util.addWords(this.sourceValue, this.incWord, 0);
                System.arraycopy(this.temp, 0, this.sourceValue, 0, this.temp.length);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                }
                this.cpu.flags[4] = Util.test_AF_ADD(this.oldSource[1], this.sourceValue[1]);
                this.cpu.flags[11] = Util.test_OF_ADD(this.oldSource, this.incWord, this.sourceValue, 0);
                this.cpu.flags[6] = this.sourceValue[0] == 0 && this.sourceValue[1] == 0;
                this.cpu.flags[7] = this.sourceValue[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[1]);
                break;
            }
            case 1: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                System.arraycopy(this.sourceValue, 0, this.oldSource, 0, this.sourceValue.length);
                this.temp = Util.subtractWords(this.sourceValue, this.incWord, 0);
                System.arraycopy(this.temp, 0, this.sourceValue, 0, this.temp.length);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                }
                this.cpu.flags[4] = Util.test_AF_SUB(this.oldSource[1], this.sourceValue[1]);
                this.cpu.flags[11] = Util.test_OF_SUB(this.oldSource, this.incWord, this.sourceValue, 0);
                this.cpu.flags[6] = this.sourceValue[0] == 0 && this.sourceValue[1] == 0;
                this.cpu.flags[7] = this.sourceValue[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[1]);
                break;
            }
            case 2: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.newIP = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.newIP = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.cpu.setWordToStack(this.cpu.ip);
                this.cpu.ip[1] = this.newIP[1];
                this.cpu.ip[0] = this.newIP[0];
                break;
            }
            case 3: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)this.cpu.getType()) + "]" + " Instruction INCDEC_GRP5 (0xFF): CALLF in unsupported case.");
                    break;
                }
                this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.newIP = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.temp = Util.addWords(new byte[]{0, 2}, this.memoryReferenceDisplacement, 0);
                System.arraycopy(this.temp, 0, this.memoryReferenceDisplacement, 0, this.temp.length);
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.newCS = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.cpu.setWordToStack(this.cpu.cs);
                this.cpu.setWordToStack(this.cpu.ip);
                this.cpu.cs[1] = this.newCS[1];
                this.cpu.cs[0] = this.newCS[0];
                this.cpu.ip[1] = this.newIP[1];
                this.cpu.ip[0] = this.newIP[0];
                break;
            }
            case 4: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.newIP = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.cpu.ip[1] = this.newIP[1];
                    this.cpu.ip[0] = this.newIP[0];
                    break;
                }
                this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.newIP = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.cpu.ip[1] = this.newIP[1];
                this.cpu.ip[0] = this.newIP[0];
                break;
            }
            case 5: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)this.cpu.getType()) + "]" + " Instruction INCDEC_GRP5 (0xFF): JMPF in unsupported case.");
                    break;
                }
                this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.newIP = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.temp = Util.addWords(new byte[]{0, 2}, this.memoryReferenceDisplacement, 0);
                System.arraycopy(this.temp, 0, this.memoryReferenceDisplacement, 0, this.temp.length);
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.newCS = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.cpu.cs[1] = this.newCS[1];
                this.cpu.cs[0] = this.newCS[0];
                this.cpu.ip[1] = this.newIP[1];
                this.cpu.ip[0] = this.newIP[0];
                break;
            }
            case 6: {
                this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.cpu.setWordToStack(this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation));
                break;
            }
            default: {
                logger.log(Level.SEVERE, "[" + (Object)((Object)this.cpu.getType()) + "]" + " Instruction INCDEC_GRP5 (0xFF): no group instruction match.");
            }
        }
    }
}

